import { api } from "encore.dev/api";
import { SQLDatabase } from "encore.dev/storage/sqldb";

const db = SQLDatabase.named("madrasah");

export interface CreateAlumniRequest {
  madrasah_id: string;
  nisn?: string;
  nis?: string;
  nama_lengkap: string;
  tempat_lahir?: string;
  tanggal_lahir?: string;
  jenis_kelamin?: string;
  agama?: string;
  alamat?: string;
  no_telepon?: string;
  tahun_lulus: number;
  melanjutkan_ke?: string;
  pekerjaan?: string;
  alamat_sekarang?: string;
}

export interface Alumni {
  id: string;
  madrasah_id: string;
  nisn: string;
  nis: string;
  nama_lengkap: string;
  tempat_lahir: string;
  tanggal_lahir: string;
  jenis_kelamin: string;
  agama: string;
  alamat: string;
  no_telepon: string;
  tahun_lulus: number;
  melanjutkan_ke: string;
  pekerjaan: string;
  alamat_sekarang: string;
}

// Creates a new alumni
export const createAlumni = api<CreateAlumniRequest, Alumni>(
  { expose: true, method: "POST", path: "/alumni" },
  async (req) => {
    const alumni = await db.queryRow<Alumni>`
      INSERT INTO alumni (madrasah_id, nisn, nis, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                         no_telepon, tahun_lulus, melanjutkan_ke, pekerjaan, alamat_sekarang)
      VALUES (${req.madrasah_id}, ${req.nisn || ""}, ${req.nis || ""}, ${req.nama_lengkap}, ${req.tempat_lahir || ""}, 
              ${req.tanggal_lahir || null}, ${req.jenis_kelamin || ""}, ${req.agama || ""}, ${req.alamat || ""}, 
              ${req.no_telepon || ""}, ${req.tahun_lulus}, ${req.melanjutkan_ke || ""}, ${req.pekerjaan || ""}, 
              ${req.alamat_sekarang || ""})
      RETURNING id, madrasah_id, nisn, nis, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                no_telepon, tahun_lulus, melanjutkan_ke, pekerjaan, alamat_sekarang
    `;
    
    return alumni!;
  }
);
